<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Digeco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Base;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Working_Process extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Working Process', 'digeco-core' );
		$this->rt_base = 'rt-working-process';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'digeco-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'digeco-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'digeco-core' ),
					'style2' => esc_html__( 'Style 2', 'digeco-core' ),
					'style3' => esc_html__( 'Style 3', 'digeco-core' ),
					'style4' => esc_html__( 'Style 4', 'digeco-core' ),
					'style5' => esc_html__( 'Style 5', 'digeco-core' ),
					'style6' => esc_html__( 'Style 6', 'digeco-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'theme',
				'label'   => esc_html__( 'Theme', 'digeco-core' ),
				'options' => array(
					'lefticon' => esc_html__( 'Left Icon', 'digeco-core' ),
					'righticon' => esc_html__( 'Right Icon', 'digeco-core' ),
				),
				'default' => 'lefticon',
				'condition'   => array( 'style' => array( 'style4' ) ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_display',
				'label'   => esc_html__( 'Animation Off/On', 'digeco-core' ),
				'options' => array(
					'has-animation'   => esc_html__( 'On', 'digeco-core' ),
					'no-animation'    => esc_html__( 'Off', 'digeco-core' ),
				),
				'default' => 'has-animation',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Animation Delay', 'digeco-core' ),
				'default' => '100',
				'condition'   => array( 'animation_display' => array( 'has-animation' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'process_no',
				'label'   => esc_html__( 'Process No', 'digeco-core' ),
				'default' => '1',
				'condition'   => array( 'style' => array( 'style1', 'style5' ) ),
			),
			/*Icon Start*/
			
			array(					 
			   'type'    => Controls_Manager::CHOOSE,
			   'options' => [
			     'icon' => [
			       'title' => esc_html__( 'Left', 'digeco-core' ),
			       'icon' => 'fa fa-smile-o',
			     ],
			     'image' => [
			       'title' => esc_html__( 'Center', 'digeco-core' ),
			       'icon' => 'fa fa-image',
			     ],		     
			   ],
			   'id'      => 'icontype',
			   'label'   => esc_html__( 'Media Type', 'digeco-core' ),
			   'default' => 'icon',
			   'label_block' => false,
			   'toggle' => false,
				'condition'   => array( 'style' => array( 'style6' ) ),
			),			
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'icon_class',
				'label'   => esc_html__( 'Icon', 'digeco-core' ),
				'default' => array(
			      'value' => 'fas fa-smile-wink',
			      'library' => 'fa-solid',
				),
				'condition'   => array('icontype' => array( 'icon' ), 'style' => array( 'style1', 'style2', 'style3', 'style4', 'style5', 'style6' ) ),
			),			
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'icon_image',
				'label'   => esc_html__( 'Image', 'digeco-core' ),
				'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
				'condition'   => array('icontype' => array( 'image' ), 'style' => array( 'style6' ) ),
				'description' => esc_html__( 'Recommended full image', 'digeco-core' ),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'roofit-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',		
				'condition'   => array('icontype' => array( 'image' ), 'style' => array( 'style6' ) ),
			),			
			/*Icon end*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'icon_size',
				'label'   => esc_html__( 'Icon Size', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-default .rtin-item .rtin-icon i' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .working-process-default .rtin-item .rtin-icon i:before' => 'font-size: {{VALUE}}px',
				),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'digeco-core' ),
				'default' => esc_html__( 'Development', 'digeco-core' ),
			),			
			array(
				'type'    => Controls_Manager::WYSIWYG,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'digeco-core' ),
				'default' => esc_html__( 'Grursus mal suada faci ipsum to and the and dolarorit ametion consectetur elitto more bulum that odio', 'digeco-core' ),
				'condition'   => array( 'style' => array( 'style2', 'style3', 'style4' ) ),
			),
			array(
				'type'  => Controls_Manager::URL,
				'id'    => 'url',
				'label' => esc_html__( 'Link (Optional)', 'digeco-core' ),
				'placeholder' => 'https://your-link.com',
			),
			array(
				'mode' => 'section_end',
			),
			
			/*Title Style Option*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_style',
				'label'   => esc_html__( 'Style', 'digeco-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Style', 'digeco-core' ),
				'selector' => '{{WRAPPER}} .working-process-default .rtin-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-default .rtin-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .working-process-default .rtin-title a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => esc_html__( 'Content Color', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-default .rtin-text' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2', 'style3', 'style4' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon Color', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-default .rtin-item .rtin-icon i' => 'color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_hover_color',
				'label'   => esc_html__( 'Icon Hover Color', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-default .rtin-item:hover .rtin-icon i' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2', 'style4' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_bag_color',
				'label'   => esc_html__( 'Icon Background Color', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-default .rtin-item .rtin-icon' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2', 'style4' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_bag_hover_color',
				'label'   => esc_html__( 'Icon Background Hover Color', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-default .rtin-item:hover .rtin-icon' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2', 'style4' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'no_color',
				'label'   => esc_html__( 'Number Color', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-style5 .count-number' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style5' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'no_bag_color',
				'label'   => esc_html__( 'Number Background Color', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-style5 .count-number' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style5' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'box_bag_color',
				'label'   => esc_html__( 'Box Background Color', 'digeco-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .working-process-style5 .rtin-item' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style5' ) ),
			),	
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		switch ( $data['style'] ) {
			case 'style6':
			$template = 'working-process-6';
			break;
			case 'style5':
			$template = 'working-process-5';
			break;
			case 'style4':
			$template = 'working-process-4';
			break;
			case 'style3':
			$template = 'working-process-3';
			break;
			case 'style2':
			$template = 'working-process-2';
			break;
			default:
			$template = 'working-process-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}